import numpy as np
import matplotlib.pyplot as plt
import matplotlib.backends.backend_tkagg as bt
import tkinter as tk

a = 5
f = 3

start = 0
stop = 0.99
num = 100

t = np.linspace(start, stop, num)
y = a*np.sin(2*np.pi*f*t)

root = tk.Tk()
root.title('Sine Wave Plot')
root.geometry('800x600')

fig, ax = plt.subplots(layout='constrained')
canvas = bt.FigureCanvasTkAgg(fig, root)
canvas.get_tk_widget().pack()

ax.plot(t, y)
plt.xlabel('Time (s)')
plt.ylabel('Sine-Wave Displacement (cm)')

canvas.draw()

root.mainloop()
